unit Question4_u;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls;

type
  TfrmQuestion4 = class(TForm)
    pgcBirthdays: TPageControl;
    tbsCheck: TTabSheet;
    redBirthdays: TRichEdit;
    btnDisplay: TButton;
    edtYear: TLabeledEdit;
    edtMonth: TLabeledEdit;
    edtDay: TLabeledEdit;
    tbsAddBirthday: TTabSheet;
    edtName: TLabeledEdit;
    edtSurname: TLabeledEdit;
    edtGender: TLabeledEdit;
    edtBday: TLabeledEdit;
    edtBmonth: TLabeledEdit;
    edtByear: TLabeledEdit;
    btnAddBirthday: TButton;
    procedure btnDisplayClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnAddBirthdayClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmQuestion4: TfrmQuestion4;
  tfBirthdays: TextFile;
  sToday, sCyear, sCMonth, sCDay: string;

implementation

{$R *.dfm}

procedure TfrmQuestion4.FormCreate(Sender: TObject);
begin
  // --------------------------------4.1.1----------------------------------------
  sToday := DateToStr(date); { 1 }
  edtYear.Text := Copy(sToday, 1, 4);
  edtMonth.Text := Copy(sToday, 6, 2);
  edtDay.Text := Copy(sToday, 9, 2); { 2 }

  // --------------------------------4.1.2----------------------------------------
  if FileExists('Birthdays.txt') then
    AssignFile(tfBirthdays, 'Birthdays.txt') { 1 }
  else
    ShowMessage('File does not exist.'); { 1 }
end;

procedure TfrmQuestion4.btnDisplayClick(Sender: TObject);
var
  sLine: string;
  sName, sSurname, sGender, sGrade: string;
  sbMonth, sbDay, sbYear: string;
  iAge, iNumBirthdays: integer;
begin
  // --------------------------------4.2----------------------------------------
  Reset(tfBirthdays);

  redBirthdays.Clear;
  iNumBirthdays := 0;

  sCyear := edtYear.Text;
  sCMonth := edtMonth.Text;
  sCDay := edtDay.Text;

  while NOT Eof(tfBirthdays) do
  begin
    Readln(tfBirthdays, sLine);
    sName := Copy(sLine, 1, Pos(',', sLine) - 1);
    Delete(sLine, 1, Pos(',', sLine));

    sSurname := Copy(sLine, 1, Pos(',', sLine) - 1);
    Delete(sLine, 1, Pos(',', sLine));

    sGender := Copy(sLine, 1, 1);
    Delete(sLine, 1, 2);

    sbYear := Copy(sLine, 1, 4);
    sbMonth := Copy(sLine, 6, 2);
    sbDay := Copy(sLine, 9, 2);

    if (sCMonth = sbMonth) AND (sCDay = sbDay) then
    begin
      iAge := StrToInt(sCyear) - StrToInt(sbYear);
      redBirthdays.Lines.Add(sName + ' ' + sSurname + ' is ' + IntToStr(iAge)
          + ' years old on this day.');
      inc(iNumBirthdays);
    end;
  end;
  redBirthdays.Lines.Add(#13 + 'Total birthdays: ' + IntToStr(iNumBirthdays));
end;

procedure TfrmQuestion4.btnAddBirthdayClick(Sender: TObject);
var
  sName, sSurname, sGender, sGrade: string;
  sbMonth, sbDay, sbYear: string;
  sAddLine: string;
begin
  // --------------------------------4.3----------------------------------------
  sName := edtName.Text;
  sSurname := edtSurname.Text;
  sGender := UpCase(edtGender.Text[1]);
  sbYear := edtByear.Text;
  sbDay := edtBday.Text;
  sbMonth := edtBmonth.Text;

  if (sGender = 'M') OR (sGender = 'F') then
  begin
    sAddLine := sName + ',' + sSurname + ',' + sGender + ',' + sbYear + '-' +
      sbMonth + '-' + sbDay;
    Append(tfBirthdays);
    Writeln(tfBirthdays, sAddLine);
    CloseFile(tfBirthdays);
    ShowMessage(edtName.Text + ' ' + edtSurname.Text + ' has been added.');
  end
  else
  begin
    ShowMessage('Please enter "M" or "F" in the Gender field.');
    edtGender.Clear;
    edtGender.SetFocus;
  end;

end;

end.
